function [upd,pred,T,V,S,F]=KalmanFilter (sigma, obs)

obsd=open('datatask9.mat');
z=obsd.datareg(:,3);

%---------- Create matrices-------------------------
T=size(obs,1); upd=zeros(T+1,2); pred=zeros(T,2);
V=zeros(T,1);S=zeros(T,1);F=zeros(T,1);

%---------- initial values for prediction ----------------
upd(1,:)=[0,10^7] ;% Start arbitrarily large number (non stationary)
q=sigma(1);
h=sigma(2)
%h=100*q;
for i=1:T

%---------- Prediction equation --------------------------
pred(i,1)=upd(i,1);
pred(i,2)=upd(i,2)+q;

%---------- Updating equation ----------------------------

F(i)=pred(i,2)*z(i)*z(i)+h;


upd(i+1,1)=pred(i,1)+pred(i,2)*z(i)/F(i)*(obs(i)-pred(i,1)*z(i));


upd(i+1,2)=pred(i,2)-pred(i,2)/F(i)*pred(i,2)*z(i)*z(i);


V(i)=obs(i)-pred(i,1)*z(i);

S(i)=V(i)^2/F(i);
end;